/**
 * 
 */
package gov.va.med.mhv.urlrewrite.rules;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.tuckey.web.filters.urlrewrite.RequestProxy;
import org.tuckey.web.filters.urlrewrite.extend.RewriteMatch;

/**
 * @author DNS
 *
 */
public class VeteransBenefitHandbookRewriteMatch extends RewriteMatch {
	
	private static final String ATTR_EAUTH_LASTNAME 			= "LIFERAY_SHARED_va_eauth_lastname";
	private static final String ATTR_EAUTH_FIRSTNAME 			= "LIFERAY_SHARED_va_eauth_firstname";
	private static final String ATTR_EAUTH_SUFFIX				= "LIFERAY_SHARED_va_eauth_suffix";
	private static final String ATTR_EAUTH_GENDER 				= "LIFERAY_SHARED_va_eauth_gender";
	private static final String ATTR_EAUTH_ICN 					= "LIFERAY_SHARED_va_eauth_icn";
	private static final String ATTR_EAUTH_TARGET				= "LIFERAY_SHARED_vhb_target_location";

	private static final String HEADER_EAUTH_LASTNAME 			= "va_eauth_lastname";
	private static final String HEADER_EAUTH_FIRSTNAME 			= "va_eauth_firstname";
	private static final String HEADER_EAUTH_SUFFIX 			= "va_eauth_suffix";
	private static final String HEADER_EAUTH_GENDER 			= "va_eauth_gender";
	private static final String HEADER_EAUTH_ICN 				= "va_eauth_icn";
	
	private String requestedURI;
	
	public VeteransBenefitHandbookRewriteMatch(String requestedURI) {
		this.requestedURI = requestedURI;
	}

	public boolean execute(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		Object target = request.getSession().getAttribute(ATTR_EAUTH_TARGET);
		if(target == null || "".equals(target)) {
			throw new ServletException("Session lacking VHB Taret Location URI.");
		}
		
		String targetUri = ((String)target) + this.requestedURI;

		// add the required headers
		request = addEauthHeadersFromSession(request);

		// Use the request proxy to proxy the request to the backend system
		RequestProxy.execute(targetUri, request, response);

		return true;
	}


	private HttpServletRequest addEauthHeadersFromSession(HttpServletRequest request) {
		
		HttpSession session = request.getSession();
		
		// validates that the required attributes are in the session; throws an
		// IllegalArgumentException with a descriptive message if they are not.
		validateRequiredAttributes(session);
		
		// create the request wrapper that allows the addition of headers
		HeaderMapRequestWrapper headerMapRequest = new HeaderMapRequestWrapper(request);
		
		// add the required headers
		headerMapRequest.addHeader(HEADER_EAUTH_LASTNAME, (String)session.getAttribute(ATTR_EAUTH_LASTNAME));
		headerMapRequest.addHeader(HEADER_EAUTH_FIRSTNAME, (String)session.getAttribute(ATTR_EAUTH_FIRSTNAME));
		headerMapRequest.addHeader(HEADER_EAUTH_SUFFIX, (String)session.getAttribute(ATTR_EAUTH_SUFFIX));
		headerMapRequest.addHeader(HEADER_EAUTH_GENDER, (String)session.getAttribute(ATTR_EAUTH_GENDER));
		headerMapRequest.addHeader(HEADER_EAUTH_ICN, (String)session.getAttribute(ATTR_EAUTH_ICN));
		
		return headerMapRequest;
	}
	
	/*
	 * Validates that non of the required parameters are null or empty.
	 */
	private void validateRequiredAttributes(HttpSession session) {
		Boolean hasLastName = session.getAttribute(ATTR_EAUTH_LASTNAME) != null && !"".equals(session.getAttribute(ATTR_EAUTH_LASTNAME));
		Boolean hasFirstName = session.getAttribute(ATTR_EAUTH_FIRSTNAME) != null && !"".equals(session.getAttribute(ATTR_EAUTH_FIRSTNAME));
		Boolean hasGender = session.getAttribute(ATTR_EAUTH_GENDER) != null && !"".equals(session.getAttribute(ATTR_EAUTH_GENDER));
		Boolean hasIcn = session.getAttribute(ATTR_EAUTH_ICN) != null && !"".equals(session.getAttribute(ATTR_EAUTH_ICN));
		
		Boolean hasRequired = hasLastName && hasFirstName && hasGender && hasIcn;
		if(!hasRequired) {
			String errorMessage = String.format("Required parameters not found. First Name: %s, Last Name; %s, Gender: %s, ICN: %s", 
					session.getAttribute(ATTR_EAUTH_FIRSTNAME), session.getAttribute(ATTR_EAUTH_LASTNAME),
					session.getAttribute(ATTR_EAUTH_GENDER), session.getAttribute(ATTR_EAUTH_ICN));
			throw new IllegalArgumentException(errorMessage);
		}
	}
	
	private class HeaderMapRequestWrapper extends HttpServletRequestWrapper {
		/**
		 * construct a wrapper for this request
		 * 
		 * @param request
		 */
		public HeaderMapRequestWrapper(HttpServletRequest request) {
			super(request);
		}

		private Map<String, String> headerMap = new HashMap<String, String>();

		/**
		 * add a header with given name and value
		 * 
		 * @param name
		 * @param value
		 */
		public void addHeader(String name, String value) {
			headerMap.put(name, value);
		}

		@Override
		public String getHeader(String name) {
			String headerValue = super.getHeader(name);
			if (headerMap.containsKey(name)) {
				headerValue = headerMap.get(name);
			}
			return headerValue;
		}

		/**
		 * get the Header names
		 */
		@Override
		public Enumeration<String> getHeaderNames() {
			List<String> names = Collections.list(super.getHeaderNames());
			for (String name : headerMap.keySet()) {
				names.add(name);
			}
			return Collections.enumeration(names);
		}

		@Override
		public Enumeration<String> getHeaders(String name) {
			List<String> values = Collections.list(super.getHeaders(name));
			if (headerMap.containsKey(name)) {
				values.add(headerMap.get(name));
			}
			return Collections.enumeration(values);
		}

	}

}
